import type { DefaultExtensionConfiguration } from "@smithy/types";
import { getChecksumConfiguration } from "./checksum";
/**
 * @internal
 */
export type DefaultExtensionConfigType = Parameters<typeof getChecksumConfiguration>[0];
/**
 * @internal
 *
 * Helper function to resolve default extension configuration from runtime config
 */
export declare const getDefaultExtensionConfiguration: (runtimeConfig: DefaultExtensionConfigType) => {
    _checksumAlgorithms: import("@smithy/types").ChecksumAlgorithm[];
    addChecksumAlgorithm(algo: import("@smithy/types").ChecksumAlgorithm): void;
    checksumAlgorithms(): import("@smithy/types").ChecksumAlgorithm[];
};
/**
 * @deprecated use getDefaultExtensionConfiguration
 * @internal
 *
 * Helper function to resolve default extension configuration from runtime config
 */
export declare const getDefaultClientConfiguration: (runtimeConfig: DefaultExtensionConfigType) => {
    _checksumAlgorithms: import("@smithy/types").ChecksumAlgorithm[];
    addChecksumAlgorithm(algo: import("@smithy/types").ChecksumAlgorithm): void;
    checksumAlgorithms(): import("@smithy/types").ChecksumAlgorithm[];
};
/**
 * @internal
 *
 * Helper function to resolve runtime config from default extension configuration
 */
export declare const resolveDefaultRuntimeConfig: (config: DefaultExtensionConfiguration) => {
    md5?: import("@smithy/types").HashConstructor | import("@smithy/types").ChecksumConstructor | undefined;
    crc32?: import("@smithy/types").HashConstructor | import("@smithy/types").ChecksumConstructor | undefined;
    crc32c?: import("@smithy/types").HashConstructor | import("@smithy/types").ChecksumConstructor | undefined;
    sha1?: import("@smithy/types").HashConstructor | import("@smithy/types").ChecksumConstructor | undefined;
    sha256?: import("@smithy/types").HashConstructor | import("@smithy/types").ChecksumConstructor | undefined;
};
